<?php

/**
 * Fired during plugin activation
 *
 * @link       https://mhrtheme.com
 * @since      1.1
 *
 * @package    Star_Addons_For_Elementor
 * @subpackage Star_Addons_For_Elementor/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.1
 * @package    Star_Addons_For_Elementor
 * @subpackage Star_Addons_For_Elementor/includes
 * @author     MhrTheme <hello@mhrtheme.com>
 */
class Star_Addons_For_Elementor_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.1
	 */
	public static function activate() {
		// Store activation timestamp and other persistent data
		update_option('star_addons_activated', current_time('mysql'));
		update_option('star_addons_version', STAR_ADDONS_FOR_ELEMENTOR_VERSION);
		
		// Create custom database table if needed
		self::create_plugin_tables();
		
		// Set default options
		self::set_default_options();
	}
	
	/**
	 * Create custom database tables for persistent data
	 */
	private static function create_plugin_tables() {
		global $wpdb;
		
		$table_name = $wpdb->prefix . 'star_addons_data';
		
		$charset_collate = $wpdb->get_charset_collate();
		
		$sql = "CREATE TABLE $table_name (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			option_name varchar(255) NOT NULL,
			option_value longtext NOT NULL,
			created_at datetime DEFAULT CURRENT_TIMESTAMP,
			PRIMARY KEY (id),
			UNIQUE KEY option_name (option_name)
		) $charset_collate;";
		
		require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
		dbDelta($sql);
	}
	
	/**
	 * Set default persistent options
	 */
	private static function set_default_options() {
		$defaults = array(
			'star_addons_settings' => array(
				'license_key' => '',
				'auto_updates' => true,
				'analytics' => false
			)
		);
		
		foreach($defaults as $option => $value) {
			if(!get_option($option)) {
				update_option($option, $value);
			}
		}
	}

}
