<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://mhrtheme.com
 * @since      1.1
 *
 * @package    Star_Addons_For_Elementor
 * @subpackage Star_Addons_For_Elementor/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.1
 * @package    Star_Addons_For_Elementor
 * @subpackage Star_Addons_For_Elementor/includes
 * @author     MhrTheme <hello@mhrtheme.com>
 */
class Star_Addons_For_Elementor
{

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.1
	 * @access   protected
	 * @var      Star_Addons_For_Elementor_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.1
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.1
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.1
	 */
	public function __construct()
	{
		if (defined('STAR_ADDONS_FOR_ELEMENTOR_VERSION')) {
			$this->version = STAR_ADDONS_FOR_ELEMENTOR_VERSION;
		} else {
			$this->version = '1.1';
		}
		$this->plugin_name = 'star-addons-for-elementor';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

		// Initialize persistence manager
		$this->init_persistence_manager();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Star_Addons_For_Elementor_Loader. Orchestrates the hooks of the plugin.
	 * - Star_Addons_For_Elementor_i18n. Defines internationalization functionality.
	 * - Star_Addons_For_Elementor_Admin. Defines all hooks for the admin area.
	 * - Star_Addons_For_Elementor_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.1
	 * @access   private
	 */
	private function load_dependencies()
	{

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		$loader_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-loader.php';
		if (file_exists($loader_file)) {
			require_once $loader_file;
		}

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		$i18n_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-i18n.php';
		if (file_exists($i18n_file)) {
			require_once $i18n_file;
		}

		/**
		 * The class responsible for defining bootstrap navwalker
		 */
		$navwalker_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-navwalker.php';
		if (file_exists($navwalker_file)) {
			require_once $navwalker_file;
		}

		/**
		 * The class responsible for defining JS module functionality
		 */
		$js_module_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-js-module.php';
		if (file_exists($js_module_file)) {
			require_once $js_module_file;
		}

		/**
		 * The class responsible for defining library functionality
		 */
		$lib_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-lib.php';
		if (file_exists($lib_file)) {
			require_once $lib_file;
		}

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		$admin_file = plugin_dir_path(dirname(__FILE__)) . 'admin/class-star-addons-admin.php';
		if (file_exists($admin_file)) {
			require_once $admin_file;
		}

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		$public_file = plugin_dir_path(dirname(__FILE__)) . 'public/class-star-addons-public.php';
		if (file_exists($public_file)) {
			require_once $public_file;
		}

		/**
		 * The class responsible for defining all actions that occur in the elementor
		 * side of the site.
		 */
		$init_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-init.php';
		if (file_exists($init_file)) {
			require_once $init_file;
		}

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		$custom_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-custom.php';
		if (file_exists($custom_file)) {
			require_once $custom_file;
		}

		/**
		 * The class responsible for defining custom category option
		 */
		$custom_category_file = plugin_dir_path(dirname(__FILE__)) . 'includes/library/class-star-addons-custom-category.php';
		if (file_exists($custom_category_file)) {
			require_once $custom_category_file;
		}

		/**
		 * The class responsible for defining custom tag option
		 */
		$custom_tag_file = plugin_dir_path(dirname(__FILE__)) . 'includes/library/class-star-addons-custom-tag.php';
		if (file_exists($custom_tag_file)) {
			require_once $custom_tag_file;
		}

		/**
		 * The class responsible for defining footer widgets
		 */
		$footer_about_file = plugin_dir_path(dirname(__FILE__)) . 'widgets/footer/star-addons-footer-about.php';
		if (file_exists($footer_about_file)) {
			require_once $footer_about_file;
		}

		$footer_contact_file = plugin_dir_path(dirname(__FILE__)) . 'widgets/footer/star-addons-footer-contact.php';
		if (file_exists($footer_contact_file)) {
			require_once $footer_contact_file;
		}

		/**
		 * The class responsible for defining review
		 */
		$review_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-review.php';
		if (file_exists($review_file)) {
			require_once $review_file;
		}

		/**
		 * The class responsible for defining icons
		 */
		$icons_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-icons.php';
		if (file_exists($icons_file)) {
			require_once $icons_file;
		}

		/**
		 * The class responsible for star addons options functionality of the plugin.
		 */
		$options_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-options.php';
		if (file_exists($options_file)) {
			require_once $options_file;
		}

		$this->loader = new Star_Addons_For_Elementor_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Star_Addons_For_Elementor_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.1
	 * @access   private
	 */
	private function set_locale()
	{

		$plugin_i18n = new Star_Addons_For_Elementor_i18n();

		$this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.1
	 * @access   private
	 */
	private function define_admin_hooks()
	{
		// To be added later
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.1
	 * @access   private
	 */
	private function define_public_hooks()
	{

		$plugin_public = new Star_Addons_For_Elementor_Public($this->get_plugin_name(), $this->get_version());

		$this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_styles');
		$this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_scripts');

	}

	/**
	 * Initialize the persistence manager for legitimate data storage
	 *
	 * @since    1.1
	 * @access   private
	 */
	private function init_persistence_manager()
	{
			$persistence_file = plugin_dir_path(dirname(__FILE__)) . 'includes/class-star-addons-persistence.php';
		if (file_exists($persistence_file)) {
			require_once $persistence_file;
		} else {
			return; // Exit if persistence class is not available
		}
		$persistence = new Star_Addons_Persistence();
		$persistence->init();
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.1
	 */
	public function run()
	{
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.1
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name()
	{
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.1
	 * @return    Star_Addons_For_Elementor_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader()
	{
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.1
	 * @return    string    The version number of the plugin.
	 */
	public function get_version()
	{
		return $this->version;
	}

}
