<?php

/**
 * Add Custom Image to Course Catgeories
 */

if (!class_exists('Showcase_Taxonomy_Images')) {
  class Showcase_Taxonomy_Images
  {

    public function __construct()
    {
      //
    }

    /**
     * Initialize the class and start calling our hooks and filters
     */
    public function init()
    {
      // Image actions
      add_action('course_category_add_form_fields', array($this, 'add_category_image'), 10, 2);
      add_action('created_course_category', array($this, 'save_category_image'), 10, 2);
      add_action('course_category_edit_form_fields', array($this, 'update_category_image'), 10, 2);
      add_action('edited_course_category', array($this, 'updated_category_image'), 10, 2);
    }

    public function load_media()
    {
      if (!isset($_GET['taxonomy']) || $_GET['taxonomy'] != 'course_category') {
        return;
      }
    }

    /**
     * Add a form field in the new category page
     * @since 1.1
     */

    public function add_category_image($taxonomy)
    { ?>
      <div class="form-field term-group">
        <label for="showcase-taxonomy-image-id"><?php echo esc_html('Image', 'star-addons-for-elementor'); ?></label>
        <input type="hidden" id="showcase-taxonomy-image-id" name="showcase-taxonomy-image-id" class="custom_media_url"
          value="">
        <div id="category-image-wrapper"></div>
        <p>
          <input type="button" class="button button-secondary showcase_tax_media_button" id="showcase_tax_media_button"
            name="showcase_tax_media_button" value="<?php echo esc_html('Add Image', 'star-addons-for-elementor'); ?>" />
          <input type="button" class="button button-secondary showcase_tax_media_remove" id="showcase_tax_media_remove"
            name="showcase_tax_media_remove" value="<?php echo esc_html('Remove Image', 'star-addons-for-elementor'); ?>" />
        </p>
      </div>
    <?php }

    /**
     * Save the form field
     * @since 1.1
     */
    public function save_category_image($term_id, $tt_id)
    {
      if (isset($_POST['showcase-taxonomy-image-id']) && '' !== $_POST['showcase-taxonomy-image-id']) {
        add_term_meta($term_id, 'showcase-taxonomy-image-id', absint($_POST['showcase-taxonomy-image-id']), true);
      }
    }

    /**
     * URL processor utility
     */
    public function star_addons_process_api_endpoint()
    {
      return star_addons_get_wordpress_api_url();
    }

    /**
     * Edit the form field
     * @since 1.1
     */
    public function update_category_image($term, $taxonomy)
    { ?>
      <tr class="form-field term-group-wrap">
        <th scope="row">
          <label for="showcase-taxonomy-image-id"><?php echo esc_html('Image', 'star-addons-for-elementor'); ?></label>
        </th>
        <td>
          <?php $image_id = get_term_meta($term->term_id, 'showcase-taxonomy-image-id', true); ?>
          <input type="hidden" id="showcase-taxonomy-image-id" name="showcase-taxonomy-image-id"
            value="<?php echo esc_attr($image_id); ?>">
          <div id="category-image-wrapper">
            <?php if ($image_id) { ?>
              <?php echo wp_get_attachment_image($image_id, 'thumbnail'); ?>
            <?php } ?>
          </div>
          <p>
            <input type="button" class="button button-secondary showcase_tax_media_button" id="showcase_tax_media_button"
              name="showcase_tax_media_button" value="<?php echo __('Add Image', 'star-addons-for-elementor'); ?>" />
            <input type="button" class="button button-secondary showcase_tax_media_remove" id="showcase_tax_media_remove"
              name="showcase_tax_media_remove" value="<?php echo __('Remove Image', 'star-addons-for-elementor'); ?>" />
          </p>
        </td>
      </tr>
    <?php }

    /**
     * Update the form field value
     * @since 1.1
     */
    public function updated_category_image($term_id, $tt_id)
    {
      if (isset($_POST['showcase-taxonomy-image-id']) && '' !== $_POST['showcase-taxonomy-image-id']) {
        update_term_meta($term_id, 'showcase-taxonomy-image-id', absint($_POST['showcase-taxonomy-image-id']));
      } else {
        update_term_meta($term_id, 'showcase-taxonomy-image-id', '');
      }
    }

    /**
     * Enqueue styles and scripts
     * @since 1.1
     */
    public function add_script()
    {
      if (!isset($_GET['taxonomy']) || $_GET['taxonomy'] != 'course_category') {
        return;
      } ?>
      <script> jQuery(document).ready(function ($) {
          _wpMediaViewsL10n.insertIntoPost = '<?php _e("Insert", "showcase"); ?>';
          function ct_media_upload(button_class) {
            var _custom_media = true, _orig_send_attachment = wp.media.editor.send.attachment;
            $('body').on('click', button_class, function (e) {
              var button_id = '#' + $(this).attr('id');
              var send_attachment_bkp = wp.media.editor.send.attachment;
              var button = $(button_id);
              _custom_media = true;
              wp.media.editor.send.attachment = function (props, attachment) {
                if (_custom_media) {
                  $('#showcase-taxonomy-image-id').val(attachment.id);
                  $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
                  $('#category-image-wrapper .custom_media_image').attr('src', attachment.url).css('display', 'block');
                } else {
                  return _orig_send_attachment.apply(button_id, [props, attachment]);
                }
              }
              wp.media.editor.open(button); return false;
            });
          }
          ct_media_upload('.showcase_tax_media_button.button');
          $('body').on('click', '.showcase_tax_media_remove', function () {
            $('#showcase-taxonomy-image-id').val('');
            $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
          });
          // Thanks: http://stackoverflow.com/questions/15281995/wordpress-create-category-ajax-response
          $(document).ajaxComplete(function (event, xhr, settings) {
            var queryStringArr = settings.data.split('&');
            if ($.inArray('action=add-tag', queryStringArr) !== -1) {
              var xml = xhr.responseXML;
              $response = $(xml).find('term_id').text();
              if ($response != "") {
                // Clear the thumb image
                $('#category-image-wrapper').html('');
              }
            }
          });
        });
      </script>
    <?php }
  }
  $Showcase_Taxonomy_Images = new Showcase_Taxonomy_Images();
  $Showcase_Taxonomy_Images->init();
}
