<?php
/**
 * Divi Cake Child Theme
 * Functions.php
 *
 * ===== NOTES ==================================================================
 * 
 * Unlike style.css, the functions.php of a child theme does not override its 
 * counterpart from the parent. Instead, it is loaded in addition to the parent's 
 * functions.php. (Specifically, it is loaded right before the parent's file.)
 * 
 * In that way, the functions.php of a child theme provides a smart, trouble-free 
 * method of modifying the functionality of a parent theme. 
 * 
 * Discover Divi Child Themes: https://divicake.com/products/category/divi-child-themes/
 * Sell Your Divi Child Themes: https://divicake.com/open/
 * 
 * =============================================================================== */
 
function phc_scripts() {
    wp_enqueue_style( 'theme-responsive', get_stylesheet_directory_uri() . '/css/responsive.css' );
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_script(
        'custom-script',
        get_stylesheet_directory_uri() . '/js/jquery.serialtip.min.js',
        array( 'jquery' )
    );
	
}
add_action( 'wp_enqueue_scripts', 'phc_scripts' );

add_filter('use_block_editor_for_post', '__return_false', 10);
// Register Custom Post Type
function create_job_post_type() {
    $labels = array(
        'name'                  => _x( 'Jobs', 'Post Type General Name', 'text_domain' ),
        'singular_name'         => _x( 'Job', 'Post Type Singular Name', 'text_domain' ),
        'menu_name'             => __( 'Jobs', 'text_domain' ),
        'name_admin_bar'        => __( 'Job', 'text_domain' ),
        'archives'              => __( 'Job Archives', 'text_domain' ),
        'attributes'            => __( 'Job Attributes', 'text_domain' ),
        'parent_item_colon'     => __( 'Parent Job:', 'text_domain' ),
        'all_items'             => __( 'All Jobs', 'text_domain' ),
        'add_new_item'          => __( 'Add New Job', 'text_domain' ),
        'add_new'               => __( 'Add New', 'text_domain' ),
        'new_item'              => __( 'New Job', 'text_domain' ),
        'edit_item'             => __( 'Edit Job', 'text_domain' ),
        'update_item'           => __( 'Update Job', 'text_domain' ),
        'view_item'             => __( 'View Job', 'text_domain' ),
        'view_items'            => __( 'View Jobs', 'text_domain' ),
        'search_items'          => __( 'Search Job', 'text_domain' ),
        'not_found'             => __( 'Not found', 'text_domain' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'text_domain' ),
        'featured_image'        => __( 'Featured Image', 'text_domain' ),
        'set_featured_image'    => __( 'Set featured image', 'text_domain' ),
        'remove_featured_image' => __( 'Remove featured image', 'text_domain' ),
        'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
        'insert_into_item'      => __( 'Insert into job', 'text_domain' ),
        'uploaded_to_this_item' => __( 'Uploaded to this job', 'text_domain' ),
        'items_list'            => __( 'Jobs list', 'text_domain' ),
        'items_list_navigation' => __( 'Jobs list navigation', 'text_domain' ),
        'filter_items_list'     => __( 'Filter jobs list', 'text_domain' ),
    );
    $args = array(
        'label'                 => __( 'Job', 'text_domain' ),
        'description'           => __( 'Jobs', 'text_domain' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'thumbnail', 'custom-fields' ),
        'taxonomies'            => array( 'job_category' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-businessman',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
    );
    register_post_type( 'job', $args );
}
add_action( 'init', 'create_job_post_type', 0 );

// Register Custom Taxonomy
function create_job_taxonomy() {
    $labels = array(
        'name'                       => _x( 'Job Categories', 'Taxonomy General Name', 'text_domain' ),
        'singular_name'              => _x( 'Job Category', 'Taxonomy Singular Name', 'text_domain' ),
        'menu_name'                  => __( 'Job Categories', 'text_domain' ),
        'all_items'                  => __( 'All Job Categories', 'text_domain' ),
        'parent_item'                => __( 'Parent Job Category', 'text_domain' ),
        'parent_item_colon'          => __( 'Parent Job Category:', 'text_domain' ),
        'new_item_name'              => __( 'New Job Category Name', 'text_domain' ),
        'add_new_item'               => __( 'Add New Job Category', 'text_domain' ),
        'edit_item'                  => __( 'Edit Job Category', 'text_domain' ),
        'update_item'                => __( 'Update Job Category', 'text_domain' ),
        'view_item'                  => __( 'View Job Category', 'text_domain' ),
        'separate_items_with_commas' => __( 'Separate job categories with commas', 'text_domain' ),
        'add_or_remove_items'        => __( 'Add or remove job categories', 'text_domain' ),
        'choose_from_most_used'      => __( 'Choose from the most used job categories', 'text_domain' ),
        'popular_items'              => __( 'Popular Job Categories', 'text_domain' ),
        'search_items'               => __( 'Search Job Categories', 'text_domain' ),
        'not_found'                  => __( 'Not Found', 'text_domain' ),
        'no_terms'                   => __( 'No job categories', 'text_domain' ),
        'items_list'                 => __( 'Job categories list', 'text_domain' ),
        'items_list_navigation'      => __( 'Job categories list navigation', 'text_domain' ),
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
    );
    register_taxonomy( 'job_category', array( 'job' ), $args );
}
add_action( 'init', 'create_job_taxonomy', 0 );


// https://f9fb-203-215-174-25.ngrok-free.app/v1/

function send_job_to_workforce($post_id, $post) {

    if ($post->post_type !== 'job') {
        error_log("Not a job post. Skipping.");
        return;
    }

    // if ($update) {
    //     error_log("Post is being updated, not a new post. Skipping.");
    //     return;
    // }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        error_log("Autosave detected. Skipping.");
        return;
    }

    if ($post->post_status !== 'publish' || empty($post->post_date_gmt)) {
        error_log("Post is not published yet. Skipping.");
        return;
    }

    error_log("Webhook passed all checks. Sending data...");

    $secret_key = defined('WEBHOOK_SECRET_KEY') ? WEBHOOK_SECRET_KEY : '';
    $crm_api_url = defined('WORKTRONIX_WEBHOOKL') ? WORKTRONIX_WEBHOOKL.'job' : '';
    
    error_log("Webhook passed all checks. Sending data...". $secret_key);
    if (empty($secret_key) || empty($crm_api_url)) {
        error_log("Missing webhook configuration. Exiting.");
        return;
    }

    $job_data = [
        'title'        => get_the_title($post_id),
        'details'      => wp_strip_all_tags(get_the_content(null, false, $post_id)),
        'url'          => get_permalink($post_id),
        'posted_date'  => get_the_date('Y-m-d H:i:s', $post_id),
    ];

    $json_data = trim(json_encode($job_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    
    error_log("Hook Data.". $json_data);
    
    $signature = hash_hmac('sha256', $json_data, $secret_key);
    
    error_log("Signatures...". $signature);

    $response = wp_remote_post($crm_api_url, [
        'method'    => 'POST',
        'body'      => $json_data,
        'headers'   => [
            'Content-Type'  => 'application/json',
            'X-Signature'   => $signature,
            'X-Timestamp'   => time(),
        ],
    ]);

    if (is_wp_error($response)) {
        error_log("CRM Webhook Error: " . $response->get_error_message());
    } else {
        error_log("Webhook sent successfully. Response: " . print_r($response, true));
    }
}
// add_action('wp_insert_post', 'send_job_to_workforce', 20, 3);

