<?php
/**
 * Divi Cake Child Theme
 * Functions.php
 *
 * ===== NOTES ==================================================================
 * 
 * Unlike style.css, the functions.php of a child theme does not override its 
 * counterpart from the parent. Instead, it is loaded in addition to the parent's 
 * functions.php. (Specifically, it is loaded right before the parent's file.)
 * 
 * In that way, the functions.php of a child theme provides a smart, trouble-free 
 * method of modifying the functionality of a parent theme. 
 * 
 * Discover Divi Child Themes: https://divicake.com/products/category/divi-child-themes/
 * Sell Your Divi Child Themes: https://divicake.com/open/
 * 
 * =============================================================================== */
 
function phc_scripts() {
    wp_enqueue_style( 'theme-responsive', get_stylesheet_directory_uri() . '/css/responsive.css' );
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_script(
        'custom-script',
        get_stylesheet_directory_uri() . '/js/jquery.serialtip.min.js',
        array( 'jquery' )
    );
	
}
add_action( 'wp_enqueue_scripts', 'phc_scripts' );

add_filter('use_block_editor_for_post', '__return_false', 10);

